/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.gprinter.command.GpCom;
import java.util.Vector;

public abstract class GpPort {
    private static final String DEBUG_TAG = "GpPort";
    protected boolean mClosePort;
    protected int mState;
    protected Handler mHandler = null;
    protected int mmBytesAvailable;
    protected int mPrinterId;

    abstract void connect();

    abstract void stop();

    abstract GpCom.ERROR_CODE writeDataImmediately(Vector<Byte> var1);

    protected synchronized void setState(int state) {
        if (this.mState != state) {
            Log.d((String)DEBUG_TAG, (String)("setState() " + this.mState + " -> " + state));
            Log.d((String)DEBUG_TAG, (String)("PrinterId() " + this.mPrinterId + " -> " + this.mPrinterId));
            this.mState = state;
            Message msg = this.mHandler.obtainMessage(1);
            Bundle bundle = new Bundle();
            bundle.putInt("printer.id", this.mPrinterId);
            bundle.putInt("device_status", state);
            msg.setData(bundle);
            this.mHandler.sendMessage(msg);
        } else {
            Log.d((String)DEBUG_TAG, (String)"STATE NOT CHANGE");
        }
    }

    protected int getState() {
        return this.mState;
    }

    protected void connectionFailed() {
        this.setState(0);
    }

    protected void closePortFailed() {
        this.setState(0);
        Log.d((String)DEBUG_TAG, (String)"closePortFailed ");
    }

    protected void connectionLost() {
        this.setState(0);
        Log.d((String)DEBUG_TAG, (String)"connectionLost ");
    }

    protected void invalidPrinter() {
        this.setState(0);
        Message msg = this.mHandler.obtainMessage(5);
        Bundle bundle = new Bundle();
        bundle.putInt("printer.id", this.mPrinterId);
        bundle.putString("toast", "Please use Gprinter");
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
    }

    protected void connectionToPrinterFailed() {
        this.setState(0);
        Log.d((String)DEBUG_TAG, (String)"Close port failed ");
    }
}

